/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college.world;

import foxie.rpg_college.Camera;
import foxie.rpg_college.FloatRectangle;
import foxie.rpg_college.Game;
import foxie.rpg_college.IVec2;
import foxie.rpg_college.Vec2;
import foxie.rpg_college.entity.CollisionBox;
import foxie.rpg_college.entity.Entity;
import foxie.rpg_college.tile.Tile;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public abstract class World {
    private final Game game;
    private final FloatRectangle renderBound;
    private final FloatRectangle validBound;
    private final ConcurrentHashMap<Long, Entity> entities = new ConcurrentHashMap();
    private final ConcurrentHashMap<IVec2, Tile> tiles = new ConcurrentHashMap();
    private final CollisionBox[] worldBorder;
    private static final float BORDER_DEPTH = 2.0E8f;
    private static final float BORDER_INNER_DEPTH = 50.0f;

    public World(Game game, FloatRectangle bound) {
        this.game = game;
        this.renderBound = bound;
        this.validBound = new FloatRectangle(this.renderBound.getTopLeftCorner().add(new Vec2(30.0f)), this.renderBound.getBottomRightCorner().sub(new Vec2(30.0f)));
        float left = this.renderBound.getTopLeftCorner().x();
        float right = this.renderBound.getBottomRightCorner().x();
        float top = this.renderBound.getTopLeftCorner().y();
        float bottom = this.renderBound.getBottomRightCorner().y();
        float width = this.renderBound.getSize().x();
        float height = this.renderBound.getSize().y();
        if (width < 50.0f || height < 50.0f) {
            throw new IllegalArgumentException("World bound is too small");
        }
        Vec2 center = new Vec2((left + right) * 0.5f, (top + bottom) * 0.5f);
        this.worldBorder = new CollisionBox[]{new CollisionBox(new Vec2(center.x(), top - 1.0E8f), new Vec2(width + 4.0E8f, 2.000001E8f), true), new CollisionBox(new Vec2(center.x(), bottom + 1.0E8f), new Vec2(width + 4.0E8f, 2.000001E8f), true), new CollisionBox(new Vec2(left - 1.0E8f, center.y()), new Vec2(2.000001E8f, height + 4.0E8f), true), new CollisionBox(new Vec2(right + 1.0E8f, center.y()), new Vec2(2.000001E8f, height + 4.0E8f), true)};
    }

    public final Game getGame() {
        return this.game;
    }

    public final FloatRectangle getWorldBound() {
        return this.validBound;
    }

    public final FloatRectangle getRenderBound() {
        return this.renderBound;
    }

    public void addTile(IVec2 coord, Tile tile) {
        if (this.tiles.containsKey(coord)) {
            throw new IllegalStateException("Attempting to add more than one tile to same coord");
        }
        Vec2 coordInWorld = Tile.fromTileCoordToWorldCoord(coord);
        if (!this.isValidPos(coordInWorld)) {
            throw new IllegalArgumentException("Attempting to add tile to outside of world");
        }
        this.tiles.put(coord, tile);
    }

    public void addEntity(Entity entity) {
        if (this.entities.containsKey(entity.id)) {
            throw new IllegalStateException("Attempt to add same entity twice");
        }
        this.entities.put(entity.id, entity);
        if (entity.getWorld() != null) {
            entity.getWorld().removeEntity(entity);
        }
        entity.setWorld(this);
        if (!this.isValidPos(entity.getPos())) {
            entity.setPos(this.validatePos(entity.getPos()));
        }
    }

    public void removeEntity(Entity entity) {
        if (!this.entities.containsKey(entity.id)) {
            throw new IllegalStateException("Attempt to remove unknown entity");
        }
        this.entities.remove(entity.id);
        entity.setWorld(null);
    }

    public Stream<Entity> findEntitiesOverlaps(Vec2 point) {
        return this.entities.values().stream().filter(e -> {
            Optional<CollisionBox> maybeBox = e.getCollisionBox();
            if (maybeBox.isEmpty()) {
                return false;
            }
            return maybeBox.get().asRect().contains(point);
        });
    }

    void checkCollisionInner(Entity e, Entity other, CollisionBox thisBox) {
        if (other.getCollisionBox().isEmpty() || other == e) {
            return;
        }
        if (!other.canCollideWith(e) || !e.canCollideWith(other)) {
            return;
        }
        CollisionBox otherBox = other.getCollisionBox().get();
        if (thisBox.checkCollisionAndFix(otherBox)) {
            e.onCollision();
            other.onCollision();
            e.onEntityCollision(other);
            other.onEntityCollision(e);
        }
    }

    void checkCollisionWithTiles(Entity e, CollisionBox thisBox) {
        CollisionBox tempBox = new CollisionBox(new Vec2(0.0f, 0.0f), Tile.SIZE, true);
        for (Map.Entry<IVec2, Tile> coordAndTile : this.tiles.entrySet()) {
            if (!coordAndTile.getValue().isCollisionEnabled()) continue;
            if (e.getWorld() == null || e.getCollisionBox().isEmpty()) {
                return;
            }
            tempBox.setPos(Tile.fromTileCoordToWorldCoord(coordAndTile.getKey()));
            if (!thisBox.checkCollisionAndFix(tempBox)) continue;
            e.onCollision();
            e.onTileCollision(coordAndTile.getKey(), coordAndTile.getValue());
        }
    }

    void checkCollision(Entity e) {
        if (e.getWorld() == null || e.getCollisionBox().isEmpty()) {
            return;
        }
        CollisionBox thisBox = e.getCollisionBox().get();
        this.checkCollisionWithTiles(e, thisBox);
        for (Entity other : this.entities.values()) {
            if (e.getWorld() == null || e.getCollisionBox().isEmpty()) {
                return;
            }
            this.checkCollisionInner(e, other, thisBox);
            if (!other.getCollisionBox().isEmpty()) continue;
        }
        this.checkCollisionWithTiles(e, thisBox);
        for (CollisionBox otherBox : this.worldBorder) {
            if (!thisBox.checkCollisionAndFix(otherBox)) continue;
            if (e.getWorld() == null || e.getCollisionBox().isEmpty()) {
                return;
            }
            e.onCollision();
        }
    }

    protected void tickEntities(float deltaTime) {
        for (Map.Entry<IVec2, Tile> coordAndTile : this.tiles.entrySet()) {
            coordAndTile.getValue().tick(deltaTime, coordAndTile.getKey());
        }
        for (Entity e : this.entities.values()) {
            Optional<FloatRectangle> maybeCheckBounds = e.getBoxToBeCheckedForTileStep();
            if (maybeCheckBounds.isEmpty()) continue;
            FloatRectangle checkBounds = maybeCheckBounds.get();
            Vec2 topLeft = checkBounds.getTopLeftCorner().div(Tile.SIZE.x());
            Vec2 bottomRight = checkBounds.getBottomRightCorner().div(Tile.SIZE.x());
            IVec2 tileToCheckStart = new IVec2((int)Math.floor(topLeft.x()) - 1, (int)Math.floor(topLeft.y()) - 1);
            IVec2 tileToCheckEnd = new IVec2((int)Math.ceil(bottomRight.x()) + 1, (int)Math.ceil(bottomRight.y()) + 1);
            for (int y = tileToCheckStart.y(); y < tileToCheckEnd.y(); ++y) {
                for (int x = tileToCheckStart.x(); x < tileToCheckEnd.x(); ++x) {
                    IVec2 coord = new IVec2(x, y);
                    Optional<Tile> tileOptional = this.getTileAt(coord);
                    if (tileOptional.isEmpty()) continue;
                    Tile tile = tileOptional.get();
                    Vec2 tileCoord = Tile.fromTileCoordToWorldCoord(coord);
                    FloatRectangle tileRect = new FloatRectangle(tileCoord.sub(Tile.SIZE.mul(0.5f)), tileCoord.add(Tile.SIZE.mul(0.5f)));
                    if (e.getWorld() == null || e.getBoxToBeCheckedForTileStep().isEmpty()) {
                        return;
                    }
                    if (!tileRect.isIntersects(checkBounds)) continue;
                    e.onTileStep(tile, coord);
                    tile.steppedBy(e, coord);
                }
            }
        }
        for (Entity e : this.entities.values()) {
            e.tick(deltaTime);
        }
        for (int i = 0; i < 5; ++i) {
            for (Entity e : this.entities.values()) {
                this.checkCollision(e);
                if (e.getWorld() != null && !e.getCollisionBox().isEmpty()) continue;
            }
        }
    }

    protected void renderEntities(Graphics2D g, float deltaTime) {
        for (Map.Entry<IVec2, Tile> coordAndTile : this.tiles.entrySet()) {
            coordAndTile.getValue().render(g, deltaTime, coordAndTile.getKey());
        }
        for (Entity e : this.entities.values()) {
            int h;
            int w;
            int y;
            int x;
            FloatRectangle boxRender;
            FloatRectangle boxWorld;
            e.render(g, deltaTime);
            if (!this.getGame().isDebugEnabled()) continue;
            Camera camera = this.game.getCamera();
            IVec2 start = camera.translateWorldToAWTGraphicsCoord(e.getPos()).round();
            IVec2 end = camera.translateWorldToAWTGraphicsCoord(e.getPos().add(Vec2.unitVectorOfAngle(e.getRotation()).mul(50.0f))).round();
            Stroke oldStroke = g.getStroke();
            g.setColor(Color.GREEN);
            g.setStroke(new BasicStroke(5.0f * this.game.getRenderScale()));
            g.drawLine(start.x(), start.y(), end.x(), end.y());
            if (e.getCollisionBox().isPresent()) {
                boxWorld = e.getCollisionBox().get().asRect();
                boxRender = camera.translateWorldToAWTGraphicsCoord(boxWorld.getCenter(), boxWorld.getSize());
                x = (int)boxRender.getTopLeftCorner().x();
                y = (int)boxRender.getTopLeftCorner().y();
                w = (int)boxRender.getSize().x();
                h = (int)boxRender.getSize().y();
                g.drawRect(x, y, w, h);
            }
            if (e.getRenderBoundInWorld().isPresent()) {
                g.setColor(Color.MAGENTA);
                boxWorld = e.getRenderBoundInWorld().get();
                boxRender = camera.translateWorldToAWTGraphicsCoord(boxWorld.getCenter(), boxWorld.getSize());
                x = (int)boxRender.getTopLeftCorner().x();
                y = (int)boxRender.getTopLeftCorner().y();
                w = (int)boxRender.getSize().x();
                h = (int)boxRender.getSize().y();
                g.drawRect(x, y, w, h);
            }
            g.setStroke(oldStroke);
        }
    }

    public Optional<Tile> getTileAt(IVec2 pos) {
        return Optional.ofNullable(this.tiles.get(pos));
    }

    public void render(Graphics2D g, float deltaTime) {
        this.renderEntities(g, deltaTime);
    }

    public void tick(float deltaTime) {
        this.tickEntities(deltaTime);
    }

    public Vec2 validatePos(Vec2 pos) {
        return this.getWorldBound().clampCoordinate(pos);
    }

    public boolean isValidPos(Vec2 pos) {
        return this.getWorldBound().contains(pos);
    }

    public Stream<Entity> findEntities(Vec2 pos, float radius) {
        return this.entities.values().stream().filter(e -> {
            if (e.getCollisionBox().isEmpty()) {
                return false;
            }
            FloatRectangle box = e.getCollisionBox().get().asRect();
            Vec2 topLeft = box.getTopLeftCorner();
            Vec2 bottomRight = box.getBottomRightCorner();
            Vec2 bottomLeft = new Vec2(topLeft.x(), bottomRight.y());
            Vec2 topRight = new Vec2(bottomRight.x(), topLeft.y());
            if (topLeft.sub(pos).magnitude() <= radius) {
                return true;
            }
            if (topRight.sub(pos).magnitude() <= radius) {
                return true;
            }
            if (bottomLeft.sub(pos).magnitude() <= radius) {
                return true;
            }
            if (bottomRight.sub(pos).magnitude() <= radius) {
                return true;
            }
            return e.getPos().sub(pos).magnitude() <= radius;
        });
    }
}

