/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college.tile;

import foxie.rpg_college.Game;
import foxie.rpg_college.IVec2;
import foxie.rpg_college.Vec2;
import foxie.rpg_college.entity.Entity;
import java.awt.Graphics2D;

public abstract class Tile {
    public static final Vec2 SIZE = new Vec2(64.0f, 64.0f);
    protected final Game game;
    private String name = this.getClass().getName();

    public Tile(Game game) {
        this.game = game;
    }

    public final Game getGame() {
        return this.game;
    }

    public String getName(IVec2 coord) {
        return this.name;
    }

    public static Vec2 fromTileCoordToWorldCoord(IVec2 coord) {
        return new Vec2((float)coord.x() * SIZE.x(), (float)coord.y() * SIZE.y());
    }

    public abstract void steppedBy(Entity var1, IVec2 var2);

    public abstract boolean isCollisionEnabled();

    public abstract boolean canBeTicked();

    public abstract void render(Graphics2D var1, float var2, IVec2 var3);

    public abstract void tick(float var1, IVec2 var2);
}

