/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college.input;

import foxie.rpg_college.input.State;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Optional;

public class Keyboard
implements AutoCloseable {
    private final boolean[] buttonStateNow = new boolean[Button.values().length];
    private final boolean[] buttonStatePrev = new boolean[Button.values().length];
    private final State[] buttonState = new State[Button.values().length];
    private final Listener listener;
    private final Window window;

    public Keyboard(Window window) {
        this.window = window;
        this.listener = new Listener(this);
        window.addKeyListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState() {
        boolean[] blArray = this.buttonStateNow;
        synchronized (this.buttonStateNow) {
            int i;
            int numKeys = Button.values().length;
            for (i = 0; i < numKeys; ++i) {
                boolean prev = this.buttonStatePrev[i];
                boolean now = this.buttonStateNow[i];
                if (prev && now) {
                    this.buttonState[i] = State.Hold;
                    continue;
                }
                if (prev && !now) {
                    this.buttonState[i] = State.Unclicked;
                    continue;
                }
                if (!prev && now) {
                    this.buttonState[i] = State.Clicked;
                    continue;
                }
                if (prev || now) continue;
                this.buttonState[i] = State.Unhold;
            }
            for (i = 0; i < numKeys; ++i) {
                this.buttonStatePrev[i] = this.buttonStateNow[i];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public State getState(Button button) {
        return this.buttonState[button.ordinal()];
    }

    @Override
    public void close() throws Exception {
        this.window.removeKeyListener(this.listener);
    }

    public static enum Button {
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        H,
        I,
        J,
        K,
        L,
        M,
        N,
        O,
        P,
        Q,
        R,
        S,
        T,
        U,
        V,
        W,
        X,
        Y,
        Z,
        Zero,
        One,
        Two,
        Three,
        Four,
        Five,
        Six,
        Seven,
        Eight,
        Nine,
        Shift,
        Control,
        Alt,
        Windows,
        Context,
        Enter,
        Backspace,
        CapsLock,
        Tab,
        Home,
        End,
        Insert,
        Delete,
        PageUp,
        PageDown,
        Comma,
        Period,
        Backslash,
        SingleQuote,
        Slash,
        Semicolon,
        Minus,
        Equal,
        BackQuote,
        Escape,
        F1,
        F2,
        F3,
        F4,
        F5,
        F6,
        F7,
        F8,
        F9,
        F10,
        F11,
        F12,
        ArrowUp,
        ArrowDown,
        ArrowLeft,
        ArrowRight,
        Space,
        OpenBracket,
        CloseBracket;

    }

    private class Listener
    extends KeyAdapter {
        private final Keyboard owner;

        public Listener(Keyboard owner) {
            this.owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyReleased(KeyEvent e) {
            Optional<Button> button = Listener.fromVirtualKey(e.getKeyCode());
            if (button.isEmpty()) {
                return;
            }
            boolean[] blArray = this.owner.buttonStateNow;
            synchronized (this.owner.buttonStateNow) {
                this.owner.buttonStateNow[button.get().ordinal()] = false;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent e) {
            Optional<Button> button = Listener.fromVirtualKey(e.getKeyCode());
            if (button.isEmpty()) {
                return;
            }
            boolean[] blArray = this.owner.buttonStateNow;
            synchronized (this.owner.buttonStateNow) {
                this.owner.buttonStateNow[button.get().ordinal()] = true;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        private static Optional<Button> fromVirtualKey(int a) {
            switch (a) {
                case 48: {
                    return Optional.of(Button.Zero);
                }
                case 49: {
                    return Optional.of(Button.One);
                }
                case 50: {
                    return Optional.of(Button.Two);
                }
                case 51: {
                    return Optional.of(Button.Three);
                }
                case 52: {
                    return Optional.of(Button.Four);
                }
                case 53: {
                    return Optional.of(Button.Five);
                }
                case 54: {
                    return Optional.of(Button.Six);
                }
                case 55: {
                    return Optional.of(Button.Seven);
                }
                case 56: {
                    return Optional.of(Button.Eight);
                }
                case 57: {
                    return Optional.of(Button.Nine);
                }
                case 65: {
                    return Optional.of(Button.A);
                }
                case 66: {
                    return Optional.of(Button.B);
                }
                case 67: {
                    return Optional.of(Button.C);
                }
                case 68: {
                    return Optional.of(Button.D);
                }
                case 69: {
                    return Optional.of(Button.E);
                }
                case 70: {
                    return Optional.of(Button.F);
                }
                case 71: {
                    return Optional.of(Button.G);
                }
                case 72: {
                    return Optional.of(Button.H);
                }
                case 73: {
                    return Optional.of(Button.I);
                }
                case 74: {
                    return Optional.of(Button.J);
                }
                case 75: {
                    return Optional.of(Button.K);
                }
                case 76: {
                    return Optional.of(Button.L);
                }
                case 77: {
                    return Optional.of(Button.M);
                }
                case 78: {
                    return Optional.of(Button.N);
                }
                case 79: {
                    return Optional.of(Button.O);
                }
                case 80: {
                    return Optional.of(Button.P);
                }
                case 81: {
                    return Optional.of(Button.Q);
                }
                case 82: {
                    return Optional.of(Button.R);
                }
                case 83: {
                    return Optional.of(Button.S);
                }
                case 84: {
                    return Optional.of(Button.T);
                }
                case 85: {
                    return Optional.of(Button.U);
                }
                case 86: {
                    return Optional.of(Button.V);
                }
                case 87: {
                    return Optional.of(Button.W);
                }
                case 88: {
                    return Optional.of(Button.X);
                }
                case 89: {
                    return Optional.of(Button.Y);
                }
                case 90: {
                    return Optional.of(Button.Z);
                }
                case 112: {
                    return Optional.of(Button.F1);
                }
                case 113: {
                    return Optional.of(Button.F2);
                }
                case 114: {
                    return Optional.of(Button.F3);
                }
                case 115: {
                    return Optional.of(Button.F4);
                }
                case 116: {
                    return Optional.of(Button.F5);
                }
                case 117: {
                    return Optional.of(Button.F6);
                }
                case 118: {
                    return Optional.of(Button.F7);
                }
                case 119: {
                    return Optional.of(Button.F8);
                }
                case 120: {
                    return Optional.of(Button.F9);
                }
                case 121: {
                    return Optional.of(Button.F10);
                }
                case 122: {
                    return Optional.of(Button.F11);
                }
                case 123: {
                    return Optional.of(Button.F12);
                }
                case 27: {
                    return Optional.of(Button.Escape);
                }
                case 9: {
                    return Optional.of(Button.Tab);
                }
                case 20: {
                    return Optional.of(Button.CapsLock);
                }
                case 16: {
                    return Optional.of(Button.Shift);
                }
                case 17: {
                    return Optional.of(Button.Control);
                }
                case 525: {
                    return Optional.of(Button.Context);
                }
                case 18: {
                    return Optional.of(Button.Alt);
                }
                case 524: {
                    return Optional.of(Button.Windows);
                }
                case 32: {
                    return Optional.of(Button.Space);
                }
                case 44: {
                    return Optional.of(Button.Comma);
                }
                case 46: {
                    return Optional.of(Button.Period);
                }
                case 222: {
                    return Optional.of(Button.SingleQuote);
                }
                case 92: {
                    return Optional.of(Button.Backslash);
                }
                case 47: {
                    return Optional.of(Button.Slash);
                }
                case 59: {
                    return Optional.of(Button.Semicolon);
                }
                case 45: {
                    return Optional.of(Button.Minus);
                }
                case 61: {
                    return Optional.of(Button.Equal);
                }
                case 8: {
                    return Optional.of(Button.Backspace);
                }
                case 10: {
                    return Optional.of(Button.Enter);
                }
                case 155: {
                    return Optional.of(Button.Insert);
                }
                case 127: {
                    return Optional.of(Button.Delete);
                }
                case 36: {
                    return Optional.of(Button.Home);
                }
                case 35: {
                    return Optional.of(Button.End);
                }
                case 33: {
                    return Optional.of(Button.PageDown);
                }
                case 38: {
                    return Optional.of(Button.ArrowUp);
                }
                case 40: {
                    return Optional.of(Button.ArrowDown);
                }
                case 37: {
                    return Optional.of(Button.ArrowLeft);
                }
                case 39: {
                    return Optional.of(Button.ArrowRight);
                }
                case 161: {
                    return Optional.of(Button.OpenBracket);
                }
                case 162: {
                    return Optional.of(Button.CloseBracket);
                }
            }
            return Optional.empty();
        }
    }
}

