/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college.entity;

import foxie.rpg_college.Camera;
import foxie.rpg_college.FloatRectangle;
import foxie.rpg_college.Game;
import foxie.rpg_college.Vec2;
import foxie.rpg_college.entity.ArrowEntity;
import foxie.rpg_college.entity.Attackable;
import foxie.rpg_college.entity.CollisionBox;
import foxie.rpg_college.entity.Entity;
import foxie.rpg_college.entity.EntityHelper;
import foxie.rpg_college.entity.LivingEntity;
import foxie.rpg_college.entity.ProjectileEntity;
import foxie.rpg_college.texture.Texture;
import foxie.rpg_college.tile.Tile;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.Optional;

public class TurretEntity
extends LivingEntity
implements Attackable {
    private static final Vec2 SIZE = Tile.SIZE;
    private static final float COOLDOWN = 0.5f;
    private static final float POLL_TIME = 1.0f;
    private static final float LOOKUP_RADIUS = 2000.0f;
    private static final float ENGAGE_DISTANCE = 1300.0f;
    private final Texture turretDead;
    private final Texture turretReady;
    private final Texture turretNotReady;
    private final CollisionBox collisionBox = new CollisionBox(new Vec2(0.05f), SIZE, true);
    private float cooldown = -1.0f;
    private float pollDelay = -1.0f;
    private Optional<LivingEntity> currentTarget = Optional.empty();

    public TurretEntity(Game game) {
        super(game);
        this.turretReady = game.getTextureManager().getTexture("entity/turret/ready");
        this.turretDead = game.getTextureManager().getTexture("entity/turret/dead");
        this.turretNotReady = game.getTextureManager().getTexture("entity/turret/not_ready");
    }

    @Override
    public FloatRectangle getLegBox() {
        return this.collisionBox.asRect();
    }

    @Override
    public float getMaxHealth() {
        return 200.0f;
    }

    @Override
    public float getMovementSpeed() {
        return 0.0f;
    }

    @Override
    public boolean canCollideWith(Entity other) {
        return !(other instanceof ProjectileEntity) || !(((ProjectileEntity)other).getShooter() instanceof TurretEntity);
    }

    @Override
    public Optional<CollisionBox> getCollisionBox() {
        return Optional.of(this.collisionBox);
    }

    @Override
    public boolean isVisible(Camera cam) {
        return true;
    }

    @Override
    public Optional<FloatRectangle> getRenderBound() {
        return Optional.of(EntityHelper.calculateRenderBox(this, SIZE));
    }

    @Override
    public void render(Graphics2D g, float deltaTime) {
        super.render(g, deltaTime);
        Texture texture = this.turretNotReady;
        if (this.canAttack()) {
            texture = this.turretReady;
        }
        if (this.isDead()) {
            texture = this.turretDead;
        }
        EntityHelper.renderRotated(this, g, texture.image(), SIZE);
    }

    @Override
    public boolean canAttack() {
        return this.cooldown < 0.0f && !this.isDead();
    }

    @Override
    public void tick(float deltaTime) {
        LivingEntity target;
        super.tick(deltaTime);
        if (this.isDead()) {
            return;
        }
        this.cooldown -= deltaTime;
        this.pollDelay -= deltaTime;
        if (this.cooldown < 0.0f) {
            this.cooldown = -1.0f;
        }
        if (this.pollDelay < 0.0f) {
            this.pollDelay = 1.0f;
            this.tryLookForTarget();
        }
        if (this.currentTarget.isPresent() && this.currentTarget.get().getWorld() != this.getWorld()) {
            this.currentTarget = Optional.empty();
        }
        if (this.currentTarget.isPresent() && this.currentTarget.get().isDead()) {
            this.pollDelay = 1.0f;
            this.currentTarget = Optional.empty();
            this.tryLookForTarget();
        }
        if (this.currentTarget.isPresent() && !this.currentTarget.get().isDead()) {
            target = this.currentTarget.get();
            this.setRotation(target.getPos().sub(this.getPos()).calculateAngle());
        }
        if (this.canAttack() && this.currentTarget.isPresent() && EntityHelper.distanceBetween(this, target = this.currentTarget.get()) <= 1300.0f) {
            this.attack();
        }
    }

    private void tryLookForTarget() {
        Iterator potentialTargets = this.getWorld().findEntities(this.getPos(), 2000.0f).filter(e -> e != this).filter(e -> !(e instanceof TurretEntity)).filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e).filter(e -> !e.isDead()).iterator();
        LivingEntity bestEntity = null;
        float bestDistance = Float.POSITIVE_INFINITY;
        while (potentialTargets.hasNext()) {
            LivingEntity candidate = (LivingEntity)potentialTargets.next();
            float candidateDistance = EntityHelper.distanceBetween(this, candidate);
            if (!(candidateDistance < bestDistance)) continue;
            bestEntity = candidate;
            bestDistance = candidateDistance;
        }
        if (bestEntity != null) {
            this.currentTarget = Optional.of(bestEntity);
        }
    }

    @Override
    public boolean attack() {
        if (!this.canAttack()) {
            return false;
        }
        this.cooldown = 0.5f;
        ArrowEntity arrow = new ArrowEntity(this.getGame(), this);
        this.getWorld().addEntity(arrow);
        arrow.setPos(this.getPos());
        arrow.setRotation(this.getRotation());
        return true;
    }
}

