/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college;

import foxie.rpg_college.FloatRectangle;
import foxie.rpg_college.IVec2;
import foxie.rpg_college.Vec2;
import foxie.rpg_college.input.Keyboard;
import foxie.rpg_college.input.Mouse;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.util.Optional;

public class Window
implements AutoCloseable {
    public Frame window;
    public Mouse mouse;
    public Keyboard keyboard;
    public BufferStrategy bufferStrategy;
    private static final GraphicsEnvironment GRAPHICS_ENVIRONMENT = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private static final GraphicsDevice GRAPHICS_DEVICE = GRAPHICS_ENVIRONMENT.getDefaultScreenDevice();
    private static final boolean IS_FULLSCREEN_SUPPORTED = GRAPHICS_DEVICE.isFullScreenSupported();
    private int currentWidth;
    private int currentHeight;
    private boolean isClosed;
    private boolean isFullscreen = false;
    private FloatRectangle outputArea;
    private int sharedCurrentWidth;
    private int sharedCurrentHeight;
    private boolean sharedIsClosed;
    private FloatRectangle sharedOutputArea;
    private final Listener listener;
    private final float outputAspectRatio;
    private final Vec2 mouseRemappedArea;
    private final IVec2 size;
    private final IVec2 minSize;

    public Window(IVec2 size, IVec2 minSize, Vec2 mouseRemappedArea, float outputAspectRatio) {
        this.outputAspectRatio = outputAspectRatio;
        this.listener = new Listener();
        this.mouseRemappedArea = mouseRemappedArea;
        this.size = size;
        this.minSize = minSize;
        this.initWindowStuffs(true);
    }

    private void initWindowStuffs(boolean isDecorated) {
        this.window = new Frame();
        this.window.setSize(this.size.x(), this.size.y());
        this.window.setMinimumSize(new Dimension(this.minSize.x(), this.minSize.y()));
        this.window.setFocusable(true);
        this.window.setUndecorated(!isDecorated);
        this.window.setVisible(true);
        this.mouse = new Mouse(this.window, this.outputArea, this.mouseRemappedArea);
        this.keyboard = new Keyboard(this.window);
        this.window.createBufferStrategy(2);
        this.bufferStrategy = Optional.ofNullable(this.window.getBufferStrategy()).get();
        this.listener.componentResized(null);
        this.updateState();
        this.window.addWindowListener(this.listener);
        this.window.addComponentListener(this.listener);
    }

    public void toggleFullscreen() {
        if (!IS_FULLSCREEN_SUPPORTED) {
            return;
        }
        this.setFullscreen(!this.isFullscreen);
    }

    public void setFullscreen(boolean val) {
        if (val && !this.isFullscreen) {
            this.window.dispose();
            this.initWindowStuffs(false);
            GRAPHICS_DEVICE.setFullScreenWindow(this.window);
        } else if (!val && this.isFullscreen) {
            this.window.dispose();
            this.initWindowStuffs(true);
            GRAPHICS_DEVICE.setFullScreenWindow(null);
        }
        this.isFullscreen = val;
    }

    public synchronized void updateState() {
        this.mouse.updateState();
        this.keyboard.updateState();
        this.isClosed = this.sharedIsClosed;
        this.currentWidth = this.sharedCurrentWidth;
        this.currentHeight = this.sharedCurrentHeight;
        this.outputArea = this.sharedOutputArea;
    }

    public int getRenderWidth() {
        return (int)this.outputArea.getSize().x();
    }

    public int getRenderHeight() {
        return (int)this.outputArea.getSize().y();
    }

    public int getWindowWidth() {
        return this.currentWidth;
    }

    public int getWindowHeight() {
        return this.currentHeight;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public FloatRectangle getOutputArea() {
        return this.outputArea;
    }

    @Override
    public void close() throws Exception {
        this.window.removeComponentListener(this.listener);
        this.window.removeWindowListener(this.listener);
        this.window.dispose();
    }

    private FloatRectangle calcOutputArea() {
        float somethingWidth = this.outputAspectRatio;
        float somethingHeight = 1.0f;
        float somethingAspect = somethingWidth / somethingHeight;
        float actualWidth = this.window.getWidth();
        float actualHeight = this.window.getHeight();
        float neededWidthIfHeightIsScaledToFit = actualHeight * somethingAspect;
        float scale = neededWidthIfHeightIsScaledToFit > actualWidth ? actualWidth / somethingWidth : actualHeight / somethingHeight;
        float letterBoxedWidth = somethingWidth * scale;
        float letterBoxedHeight = somethingHeight * scale;
        float xOffset = Math.max((actualWidth - letterBoxedWidth) / 2.0f, 0.0f);
        float yOffset = Math.max((actualHeight - letterBoxedHeight) / 2.0f, 0.0f);
        return new FloatRectangle(new Vec2(xOffset, yOffset), new Vec2(xOffset + letterBoxedWidth, yOffset + letterBoxedHeight));
    }

    private class Listener
    implements ComponentListener,
    WindowListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowClosing(WindowEvent e) {
            Window window = Window.this;
            synchronized (window) {
                Window.this.sharedIsClosed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void componentResized(ComponentEvent e) {
            Window window = Window.this;
            synchronized (window) {
                FloatRectangle outputArea;
                Window.this.sharedOutputArea = outputArea = Window.this.calcOutputArea();
                Window.this.sharedCurrentWidth = Window.this.window.getWidth();
                Window.this.sharedCurrentHeight = Window.this.window.getHeight();
                Window.this.mouse.setWatchedArea(outputArea);
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }
}

