/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college;

import foxie.rpg_college.Util;
import foxie.rpg_college.Vec2;

public record FloatRectangle(Vec2 pos1, Vec2 pos2) {
    public Vec2 getBottomRightCorner() {
        return new Vec2(Float.max(this.pos1.x(), this.pos2.x()), Float.max(this.pos1.y(), this.pos2.y()));
    }

    public Vec2 getTopLeftCorner() {
        return new Vec2(Float.min(this.pos1.x(), this.pos2.x()), Float.min(this.pos1.y(), this.pos2.y()));
    }

    public boolean isIntersects(FloatRectangle other) {
        Vec2 thisTopLeft = this.getTopLeftCorner();
        Vec2 thisBottomRight = this.getBottomRightCorner();
        Vec2 otherTopLeft = other.getTopLeftCorner();
        Vec2 otherBottomRight = other.getBottomRightCorner();
        boolean noOverlapX = thisBottomRight.x() <= otherTopLeft.x() || otherBottomRight.x() <= thisTopLeft.x();
        boolean noOverlapY = thisBottomRight.y() <= otherTopLeft.y() || otherBottomRight.y() <= thisTopLeft.y();
        return !noOverlapX && !noOverlapY;
    }

    public boolean canFit(Vec2 size) {
        Vec2 topLeft = this.getTopLeftCorner();
        Vec2 bottomRight = this.getBottomRightCorner();
        float thisWidth = bottomRight.x() - topLeft.x();
        float thisHeight = bottomRight.y() - topLeft.y();
        return size.x() <= thisWidth && size.y() <= thisHeight;
    }

    public Vec2 getSize() {
        return this.getBottomRightCorner().sub(this.getTopLeftCorner());
    }

    public Vec2 clampCoordinate(Vec2 coord) {
        Vec2 topLeft = this.getTopLeftCorner();
        Vec2 bottomRight = this.getBottomRightCorner();
        return new Vec2(Util.clamp(coord.x(), topLeft.x(), bottomRight.x()), Util.clamp(coord.y(), topLeft.y(), bottomRight.y()));
    }

    public Vec2 getCenter() {
        return this.getTopLeftCorner().add(this.getSize().mul(0.5f));
    }

    public boolean contains(Vec2 pos) {
        Vec2 topLeft = this.getTopLeftCorner();
        Vec2 bottomRight = this.getBottomRightCorner();
        return topLeft.x() <= pos.x() && pos.x() <= bottomRight.x() && topLeft.y() <= pos.y() && pos.y() <= bottomRight.y();
    }
}

