/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college;

import foxie.rpg_college.FloatRectangle;
import foxie.rpg_college.Vec2;
import java.awt.geom.AffineTransform;

public class Camera {
    private FloatRectangle possiblePosition;
    private Vec2 viewSize;
    private Vec2 outputSize;
    private Vec2 pos = new Vec2(0.0f, 0.0f);

    public Camera(FloatRectangle worldBound, Vec2 viewSize, Vec2 outputSize) {
        if (!worldBound.canFit(viewSize)) {
            throw new IllegalArgumentException("Attempt to create camera with it viewing area larger than the world");
        }
        this.viewSize = viewSize;
        this.outputSize = outputSize;
        this.setBound(worldBound);
    }

    public FloatRectangle getVisibleWorld() {
        return new FloatRectangle(this.pos.add(this.viewSize.mul(0.5f)), this.pos.sub(this.viewSize.mul(0.5f)));
    }

    public Vec2 translateWorldToAWTGraphicsCoord(Vec2 coord) {
        return coord.sub(this.getVisibleWorld().getTopLeftCorner()).mul(this.getScale());
    }

    public FloatRectangle translateWorldToAWTGraphicsCoord(Vec2 pos, Vec2 size) {
        return new FloatRectangle(this.translateWorldToAWTGraphicsCoord(pos.sub(size.mul(0.5f))), this.translateWorldToAWTGraphicsCoord(pos.add(size.mul(0.5f))));
    }

    public Vec2 translateAWTGraphicsToWorldCoord(Vec2 coord) {
        return coord.div(this.getScale()).add(this.getVisibleWorld().getTopLeftCorner());
    }

    public Vec2 translateScreenToAWTGraphicsCoord(Vec2 coord) {
        return coord.mul(this.getScale());
    }

    public AffineTransform getWorldToAWTGraphicsAffineTransform() {
        AffineTransform transform = new AffineTransform();
        transform.scale(this.getScale().x(), this.getScale().y());
        Vec2 visible = this.getVisibleWorld().getTopLeftCorner();
        transform.translate(-visible.x(), -visible.y());
        return transform;
    }

    public Vec2 translateScreenToWorldCoord(Vec2 coord) {
        return this.translateAWTGraphicsToWorldCoord(this.translateScreenToAWTGraphicsCoord(coord));
    }

    public void setPosition(Vec2 newPos) {
        this.pos = this.possiblePosition.clampCoordinate(newPos);
    }

    public Vec2 getPosition() {
        return this.pos;
    }

    public void setBound(FloatRectangle worldBound) {
        Vec2 topLeft = worldBound.getTopLeftCorner();
        Vec2 bottomRight = worldBound.getBottomRightCorner();
        this.possiblePosition = new FloatRectangle(topLeft.add(this.viewSize.mul(0.5f)), bottomRight.sub(this.viewSize.mul(0.5f)));
        this.setPosition(this.pos);
    }

    public Vec2 getScale() {
        return this.outputSize.div(this.viewSize);
    }

    public void setOutputSize(Vec2 size) {
        this.outputSize = size;
    }
}

