/*
 * Decompiled with CFR 0.152.
 */
package foxie.rpg_college;

import foxie.rpg_college.Util;
import foxie.rpg_college.Vec2;
import java.awt.Color;
import java.awt.Graphics2D;

public class Bar {
    public static final float WIDTH = 200.0f;
    public static final float HEIGHT = 20.0f;
    public float min;
    public float val;
    public float max;
    public Color filledColor;
    public Color unfilledColor;
    public Color borderColor = Color.BLACK;

    public Bar(float min, float val, float max, Color filledColor) {
        this.min = min;
        this.val = val;
        this.max = max;
        this.filledColor = filledColor;
        this.unfilledColor = new Color((float)filledColor.getRed() / 255.0f * 0.5f, (float)filledColor.getRed() / 255.0f * 0.5f, (float)filledColor.getRed() / 255.0f * 0.5f);
    }

    public Bar(float min, float val, float max, Color filledColor, Color unfilledColor) {
        this.min = min;
        this.val = val;
        this.max = max;
        this.filledColor = filledColor;
        this.unfilledColor = unfilledColor;
    }

    public void render(float renderScale, Graphics2D g, Vec2 pos) {
        float percent = Util.clamp((this.val - this.min) / (this.max - this.min), 0.0f, 1.0f);
        int x = (int)(pos.x() - 200.0f * renderScale / 2.0f);
        int y = (int)pos.y();
        g.setColor(this.borderColor);
        g.fillRect(x, y, (int)(200.0f * renderScale), (int)(20.0f * renderScale));
        g.setColor(this.unfilledColor);
        g.fillRect((int)((float)x + 5.0f * renderScale), (int)((float)y + 5.0f * renderScale), (int)(190.0f * renderScale), (int)(10.0f * renderScale));
        g.setColor(this.filledColor);
        g.fillRect((int)((float)x + 5.0f * renderScale), (int)((float)y + 5.0f * renderScale), (int)(190.0f * percent * renderScale), (int)(10.0f * renderScale));
    }
}

